<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('dob', 'phone', 'title', 'avatar_id');

    public function Posts()
    {
        return $this->hasMany('App\Models\Post\Post');
    }

    public function tenants()
    {
        return $this->belongsToMany('Tenant');
    }

    public function member()
    {
        return $this->hasMany('Group');
    }

}